<?php

/**
 * @package    JD Builder
 * @author     Team Joomdev <info@joomdev.com>
 * @copyright  2020 www.joomdev.com
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die('Restricted access');
?>
<div class="builder-install">
   <img src="data:image/png;base64,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" alt="JD Builder">
   <span style="position: absolute;margin-left: 5px;font-size: 14px;font-weight: bold;">v<?php echo JDB_VERSION; ?><?php echo \JText::_('JDBUILDER_VERSION_LABEL'); ?></span>
   <div class="install-message">
      <p>JD Builder is a powerful drag n drop Joomla page builder that lets you design stunning looking dynamic web pages with live preview in minutes. Technical hassles removed! Joomla Development redefined...</p>
   </div>
   <div class="builder-install-actions">
      <a href="index.php?option=com_jdbuilder" class="btn btn-default">Get started</a>
   </div>
   <div class="support-link">
      <a href="https://docs.joomdev.com/category/jd-builder/" target="_blank">Documentation</a> <span>|</span> <a href="https://www.joomdev.com/jd-builder/changelog" target="_blank">Changelog</a> <span>|</span> <a href="https://www.joomdev.com/forum/jd-builder" target="_blank">Forum</a> <span>|</span> <a href="https://www.youtube.com/playlist?list=PLv9TlpLcSZTAnfiT0x10HO5GGaTJhUB1K" target="_blank">Video Tutorials</a>
   </div>
   <div class="poweredby">
      <a href="https://www.joomdev.com" target="_blank">
         <span>JoomDev</span>
      </a>
   </div>
</div>
<style>
   .builder-install {
      font-weight: normal;
      margin: 20px 0;
      padding: 140px 0;
      text-align: center;
      border-radius: 6px;
      position: relative;
      color: #fff;
      border: 1px solid #f8f8f8;
      background-color: #e8e9f9;
      background: url('data:image/png;base64,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');
      background-position: center;
      background-repeat: no-repeat;
   }

   .builder-install:after {
      content: "";
      position: absolute;
      width: 100%;
      height: 100%;
      background-image: linear-gradient(47deg, #141e30 50%, #243b55 100%);
      display: block;
      top: 0;
      left: 0;
      z-index: -1;
   }

   .builder-install p {
      margin: 0;
      font-size: 16px;
      line-height: 1.5;
      letter-spacing: .5px;
   }

   .builder-install .install-message {
      width: 90%;
      max-width: 800px;
      margin: 30px auto;
   }

   .builder-install .install-message h3 {
      display: block;
      font-size: 20px;
      line-height: 27px;
      margin: 25px 0;
   }

   .builder-install .install-message h3 span {
      display: block;
      color: #7f7f7f;
      font-size: 13px;
      font-weight: 600;
      line-height: normal;
   }

   .builder-install-actions .btn {
      color: #fff;
      overflow: hidden;
      font-size: 18px;
      box-shadow: none;
      font-weight: 400;
      padding: 15px 50px;
      border-radius: 6px;
      background-color: #1a3867;
      background-image: radial-gradient(circle farthest-corner at 10% 20%, rgba(199, 46, 149, 0.81) 0%, rgba(246, 70, 84, 1) 89.5%);
      line-height: normal;
      border: none;
      font-weight: bold;
      position: relative;
      transition: linear .1s;
   }

   .builder-install-actions .btn:after {
      top: 50%;
      width: 20px;
      opacity: 0;
      content: "";
      right: 80px;
      height: 17px;
      display: block;
      position: absolute;
      transform: translateY(-50%);
      -moz-transform: translateY(-50%);
      -webkit-transform: translateY(-50%);
      background: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAARCAYAAADdRIy+AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6OERDRjlBMjY0OTIzMTFFODkyQTI4MzYzN0ZGQ0Y1NTMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6OERDRjlBMjc0OTIzMTFFODkyQTI4MzYzN0ZGQ0Y1NTMiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo4RENGOUEyNDQ5MjMxMUU4OTJBMjgzNjM3RkZDRjU1MyIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4RENGOUEyNTQ5MjMxMUU4OTJBMjgzNjM3RkZDRjU1MyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PvXGU3IAAADpSURBVHjarNShCsJAHMfxO1iyyEw+gsFoEIMKA5uoxSfwKQSjYWASq4JVEKPggwgmi2ASFcMUdefvj3/QsMEdd3/4lO32Zey2SaWU0JwsLOEGndRVFNTkw0N9Z562ziRIAog4OnMRJDV4c3TsIki6EHM0dBEkbfWbgYsgqcKRo3065mGjm1CHM0ihP084wA7yMIRIokonPOFoKNjjO4zptTS4ltZuoQUVPhbaPsMC7PkZjmw3pQx3jk1sdzn4i01t38MiXDi2sP1SSnDl2Mr2W87BiWNryCStkwb/Qx82/D9swCtp0UeAAQDi4gvA12LkbAAAAABJRU5ErkJggg==') no-repeat;
      -webkit-transition: all .4s;
      -moz-transition: all .4s;
      transition: all .4s;
   }

   .builder-install-actions .btn:hover {
      transition: linear .1s;
   }

   .builder-install-actions .btn:hover:after {
      opacity: 1;
      right: 20px;
      margin-left: 0;
   }

   .support-link {
      color: #fff;
      padding: 30px 0 0;
      font-size: 14px;
      letter-spacing: .5px;
   }

   .support-link a {
      color: #fff;
      font-weight: normal;
      text-decoration: none;
   }

   .support-link a:hover {
      text-decoration: underline;
   }

   .poweredby {
      right: 20px;
      width: 150px;
      height: 25px;
      bottom: 20px;
      position: absolute;
      background: url('data:image/png;base64,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') no-repeat 0 0;
   }

   .poweredby a {
      bottom: 0;
      display: block;
      font-size: 0;
      left: 0;
      position: absolute;
      right: 0;
      top: 0;
   }

   .poweredby span {
      font-size: 0;
   }
</style>